<?php

namespace Rubicore\Core;

class Query_Builder_Helper{

	public string $search_query;
	public string $limit_query;
	public string $order_by_query;
	public string $filter_query;


	function __construct(array $params, array $fields) {
		$search_fields = Query_Helper::get_searchables($fields);
		$filter_fields = Query_Helper::get_filterables($fields);
		$sort_fields = Query_Helper::get_sortables($fields);

		$params['search'] = $params['search'] ?? null;
		$params['sort'] = $params['sort'] ?? null;

		$this->search_query = Query_Helper::get_search_query($params['search'], $search_fields);
		$this->filter_query = Query_Helper::get_filter_query($params, $filter_fields);
		$this->order_by_query = Query_Helper::get_sort_query($params['sort'], $sort_fields);
		$this->limit_query = Query_Helper::get_limit_query($params);
	}
}
