<?php

namespace Rubicore\Core;

final class User_Query extends Query_Builder_Helper {

	public static array $fields = array(
		array(
			'key' => 'userId',
			'internal_key' => 'ID',
			'type' => Api_Helper::TYPE_INT,
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => true
		),

		array(
			'key' => 'name',
			'internal_key' => 'display_name',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'uid',
			'internal_key' => 'user_login',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'email',
			'internal_key' => 'user_email',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'status',
			'internal_key' => 'user_status',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => true
		)
	);

	public static function get_args() {
		return Query_Helper::generate_args(self::$fields);
	}
}
