<?php

namespace Rubicore\Core;

final class Link_Transformer {

	public static function transform_in(object $data, int $author) : Link_Entity {
		$entity = new Link_Entity();

		$entity->name = $data->name ?? null;
		$entity->type = $data->type ?? null;
		$entity->short_description = $data->shortDescription ?? null;
		$entity->long_description = $data->longDescription ?? null;
		$entity->icon = $data->icon ?? null;
		$entity->url = $data->url ?? null;
		$entity->author = $author ?? 0;
		$entity->public = $data->public ?? true;
		$entity->sort = property_exists($data, 'sort') ? $data->sort : 0;

		return $entity;
	}

	public static function transform_out(object $data) : Link_Model {
		$model = new Link_Model();

		$model->id = intval($data->id);
		$model->created = $data->created;
		$model->name = $data->name;
		$model->type = $data->type;
		$model->shortDescription = $data->short_description;
		$model->longDescription = $data->long_description;
		$model->icon = $data->icon;
		$model->url = $data->url;
		$model->author = $data->user ? User_Transformer::transform_list_out($data->user) : null;
		$model->public = $data->public == '1';
		$model->nodes = $data->nodes ? array_map(fn($node) => Node_Transformer::transform_out($node), $data->nodes) : [];
		$model->linkSort = $data->linkSort;
		$model->userSort = $data->userSort;

		return $model;
	}

}
