<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class Link_Service
{
	private Link_Repository $_linkRepository;

	public function __construct()
	{
		$this->_linkRepository = new Link_Repository();
	}

	public function Create(object $linkBody, int $userId) : int
	{
		$author = property_exists($linkBody, 'author') ? $linkBody->author : $userId;
		$link_entity = Link_Transformer::transform_in($linkBody, $author);
		$link_id = $this->_linkRepository->create($link_entity);

		if (property_exists($linkBody, 'nodeIds')) {
			foreach ($linkBody->nodeIds as $node_id) {
				$this->_linkRepository->add_link_to_node(array(
					'node_id' => $node_id,
					'link_id' => $link_id
				));
			}
		}

		return $link_id;
	}


	public function Update(int $linkId, object $linkBody, WP_User $user) : void
	{
		$link = $this->_linkRepository->get_by_id($linkId);
		$author = $linkBody->author ? $linkBody->author : $user->ID;

		if (!$link) {
			Response_Helper::not_found('No link found with provided id.');
		}

		User_Helper::allowed_to('update_links', $user, intval($link->author));

		$nodes = $this->_linkRepository->get_nodes($link->id);

		foreach($nodes as $node) {
			$this->_linkRepository->remove_link_node($link->id, $node->id);
		}

		if ($linkBody->nodeIds) {
			foreach ($linkBody->nodeIds as $node_id) {
				$this->_linkRepository->add_link_to_node(array(
					'node_id' => $node_id,
					'link_id' => $linkId
				));
			}
		}

		$this->_linkRepository->update_link($linkId, Link_Transformer::transform_in($linkBody, $author));

	}
}

