<?php

namespace Rubicore\Core;

use DI\ContainerBuilder;


final class DiSystem
{
	protected $container;
	protected static $instance;

	protected function __construct()
	{
		$this->buildContainer();
	}

	public static function getInstance(): DiSystem
	{
		if (null == static::$instance) {
			static::$instance = new static();
		}

		return static::$instance;
	}


	public function getContainer(): \DI\Container
	{
		return $this->container;
	}


	protected function buildContainer()
	{
		$builder = new ContainerBuilder();
		$builder->useAutowiring(true);

		$builder->addDefinitions(RUBICORE_ROOT_DIR . '/di/definitions.php');

		$this->container = $builder->build();
	}
}
