<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class User_Link_Controller
{

	function __construct()
	{
		$this->routes();
	}


	private function routes(): void
	{
		$api = new Api_Helper('rubicore/core/v1');


		// add LINK
		$api->add_route('user/(?P<id>\d+)/link/(?P<link_id>\d+)', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			$user_repo = new User_Repository();
			$link_repo = new Link_Repository();
			$user_link_repo = new User_Link_Repository();
			$body = Request_Helper::get_body($req);

			$user_id = $req->get_param('id');
			$link_id = $req->get_param('link_id');

			if (!$user_repo->get_by_id($user_id)) {
				Response_Helper::not_found("No user found with provided id.");
			}

			if (!$link_repo->get_by_id($link_id)) {
				Response_Helper::not_found("No link found with provided id.");
			}

			if (!$user_link_repo->get($user_id, $link_id) || $body->force) {
				$user_link_repo->add($user_id, $link_id);
			}
		}, [
			'args' => [
				'force' => ['type' => Api_Helper::TYPE_BOOL, 'required' => false, 'default' => false]
			]
		]);



		// sort LINKS
		$api->add_route('user/(?P<id>\d+)/link-sort', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			$user_repo = new User_Repository();
			$user_link_repo = new User_Link_Repository();
			$body = Request_Helper::get_body($req);

			$user_id = $req->get_param('id');
			$link_ids = $req->get_param('linkIds');

			if (!$user_repo->get_by_id($user_id)) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$user_link_repo->update_sort($user_id, $link_ids);
		},
			[
				'args' => [
					'linkIds' => [
						'type' => Api_Helper::TYPE_ARRAY,
						'required' => true,
						'items' => [
							'type' => Api_Helper::TYPE_INT
						]
					]
				]
			]
		);



		// remove LINK
		$api->add_route('user/(?P<id>\d+)/link/(?P<link_id>\d+)', 'DELETE', function (WP_REST_Request $req, WP_User $user): void {
			$user_repo = new User_Repository();
			$link_repo = new Link_Repository();
			$user_link_repo = new User_Link_Repository();

			$user_id = $req->get_param('id');
			$link_id = $req->get_param('link_id');

			if (!$user_repo->get_by_id($user_id)) {
				Response_Helper::not_found("No user found with provided id.");
			}

			if (!$link_repo->get_by_id($link_id)) {
				Response_Helper::not_found("No link found with provided id.");
			}

			$user_link_repo->remove($user_id, $link_id);
		});
	}
}
