<?php

namespace Rubicore\Core;

final class Category_Repository {
	private string $category_table;
	private string $user_category_table;

	function __construct () {
		$this->category_table = Db_Helper::table('category');
		$this->user_category_table = Db_Helper::table('user_category');
	}

	public function get_by_id($input) : ?object {
		return is_numeric($input) ?
			Db_Helper::get_row("SELECT * FROM $this->category_table AS l WHERE l.id = %d", [$input]) :
			Db_Helper::get_row("SELECT * FROM $this->category_table AS l WHERE l.category_key = %s", [$input]);
	}

	public function get(array $params, array $filter) : array {
		$q = new Query_Builder_Helper($params, Category_Query::$fields);
		$where = "";
		$where = Query_Helper::add_where($q->filter_query, $where, "AND", $q->filter_query);
		$where = Query_Helper::add_where($q->search_query, $where, "AND", $q->search_query);
		$where = Query_Helper::add_where($filter['userId'], $where, "AND", Db_Helper::prepare("
			EXISTS (
				SELECT * FROM $this->user_category_table AS uci
				WHERE uci.category_id = c.id
				AND uci.user_id = %d
			)
		", [$filter['userId']]));

		$count_query = Query_Helper::get_count("FROM $this->category_table AS c $where");
		$total_count = Db_Helper::get_row($count_query)->num_rows;
		Response_Helper::set_pagination_total_header($total_count);

		$main_query = "SELECT * FROM $this->category_table AS c $where $q->order_by_query $q->limit_query";

		$rows = Db_Helper::get_rows($main_query);

		return $rows;
	}

	public function create(Category_Entity $entity) : int {
		return Db_Helper::insert('category', $entity->to_array(), $entity->get_types());
	}

	public function update(int $id, Category_Entity $entity) : bool {
		return Db_Helper::update('category', $entity->to_array(), array('id'=> $id), $entity->get_types());
	}

	public function delete(int $id) : void {
		Db_Helper::delete('category', array('id' => $id), ['%d']);
		Db_Helper::delete('category_node', array('category_id' => $id), ['%d']);
		Db_Helper::delete('user_category', array('category_id' => $id), ['%d']);
	}

}
