<?php

namespace Rubicore\Core;
use \WP_REST_Request, \WP_User;

final class Search_Controller {

	function __construct () {
		$this->routes();
	}

	private function routes() : void {
		$api = new Api_Helper('rubicore/core/v1');

		$api->add_route('search', 'GET', function (WP_REST_Request $req, WP_User $user) : array {
			$post_repo = new Post_Repository();
			$media_repo = new Media_Repository();
			$user_repo = new User_Repository();

			$posts = $post_repo->search($req->get_param('query'), $req->get_param('type'));
			Response_Helper::set_pagination_total_header(count($posts));

			$page = $req->get_param('page');
			$per_page = $req->get_param('perPage');
			$from_index = ($page - 1) * $per_page;
			$posts = array_slice($posts, $from_index, $per_page);

			return array_map(function ($post) use ($media_repo, $user_repo): Post_Model {
				$post->user = $user_repo->get_by_id($post->post_author);
				$post->media = $post->media_id ? $media_repo->get_by_id($post->media_id) : null;

				$post->post_content = null;

				return Post_Transformer::transform_out($post);
			},
				$posts
			);
		}, [
			'args' => array_merge([
				'query' => ['type' => Api_Helper::TYPE_STRING, 'required' => true],
				'type' => ['type' => [Api_Helper::TYPE_ARRAY, Api_Helper::TYPE_NULL], 'required' => false, 'items' => [
					'type' => Api_Helper::TYPE_STRING
				]],
			], Query_Helper::get_pagination_args())
		]);
	}

}
