<?php

namespace Rubicore\Core;

use Requests;
use \WP_REST_Request, \WP_User;

final class Editor_Controller {

	function __construct ()
	{
		$this->routes();
	}

	private function routes() : void
	{
		$api = new Api_Helper('rubicore/core/v1');

		$api->add_route('editor/(?P<uid>[^/]+?)', 'GET', function (WP_REST_Request $req, WP_User $user) : array {
			User_Helper::allowed_to('editor_handle', $user);

			$uid = $req->get_param('uid');
			$user = User_Service::get_by_identifier($uid);

			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$repo = new Post_Editor_Repository();
			$rows = $repo->get_by_user_id($user->id, 'editor');

			return array_map(fn($row) : Post_Editor_Model => Editor_Transformer::transform_out($row), $rows);
		}, [
			'args' => [
				'uid' => ['type' => Api_Helper::TYPE_STRING, 'required' => true]
			]
		]);


		$api->add_route('editor/(?P<uid>[^/]+?)', 'PUT', function (WP_REST_Request $req, WP_User $user) : void {
			User_Helper::allowed_to('editor_handle', $user);

			$uid = $req->get_param('uid');
			$user = User_Service::get_by_identifier($uid);

			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$body = Request_Helper::get_body($req);
			$post_ids_to_add = $body->postIds;
			$repo = new Post_Editor_Repository();

			$rows = $repo->get_by_user_id($user->id, 'editor');
			$rows = array_map(fn ($row): Post_Editor_Model => Editor_Transformer::transform_out($row), $rows);

			foreach ($rows as $row) {
				if (in_array($row->postId, $post_ids_to_add)) {
					$index_to_delete = array_search($row->postId, $post_ids_to_add);
					unset($post_ids_to_add[$index_to_delete]);

					continue;
				}

				$repo->remove($row->postId, $user->id, 'editor');
			}

			foreach ($post_ids_to_add as $post_id) {
				$repo->add($post_id, $user->id, 'editor');
			}
		},
			[
				'args' => [
					'uid' => ['type' => Api_Helper::TYPE_STRING, 'required' => true],
					'postIds' => ['type' => Api_Helper::TYPE_ARRAY, 'required' => true, 'items' => ['type' => Api_Helper::TYPE_INT]]
				]
			]
		);
	}

}
