<?php

namespace Rubicore\Core;

final class User_Transformer {

	private static function meta_transform_out(array $meta) : User_Meta_Model {
		$model = new User_Meta_Model();

		$model->avatar = isset($meta['avatar']) ? $meta['avatar'][0] : '';
		$model->description = isset($meta['description']) ? $meta['description'][0] : '';
		$model->readAlert = isset($meta['readAlert']) ? $meta['readAlert'][0] : '';
		$model->readInformation = isset($meta['readInformation']) ? $meta['readInformation'][0] : '';
		$model->readMessage = isset($meta['readMessage']) ? $meta['readMessage'][0] : '';
		$model->phone1 = isset($meta['phone1']) ? $meta['phone1'][0] : '';
		$model->phone2 = isset($meta['phone2']) ? $meta['phone2'][0] : '';

		return $model;
	}

	public static function meta_transform_in(object $meta) : User_Meta_Entity {
		$entity = new User_Meta_Entity();

		$entity->avatar = $meta->avatar ?? null;
		$entity->description = $meta->description ?? null;
		$entity->readAlert = $meta->readAlert ?? null;
		$entity->readInformation = $meta->readInformation ?? null;
		$entity->readMessage = $meta->readMessage ?? null;
		$entity->phone1 = $meta->phone1 ?? null;
		$entity->phone2 = $meta->phone2 ?? null;

		return $entity;
	}

	public static function transform_out(object $data) : User_Model {
		$model = new User_Model();

		$model->id = intval($data->ID);
		$model->uid = $data->user_login;
		$model->email = $data->user_email;
		$model->name = $data->display_name;
		$model->status = $data->status ?? '';
		$model->type = $data->type ?? '';

		$model->meta = self::meta_transform_out($data->meta);

		$model->categories = $data->categories;
		$model->roles = $data->roles ?? [];

		return $model;
	}


	public static function transform_list_out(object $data): User_List_Model {
		$model = new User_List_Model();

		$model->id = intval($data->ID);
		$model->uid = $data->user_login;
		$model->email = $data->user_email;
		$model->name = $data->display_name;
		$model->avatar = isset($data->meta['avatar']) ? $data->meta['avatar'][0] : null;

		return $model;
	}
}
