const rubicore = {};

rubicore.version = (function () {
	const checkForUpdates = async function (pluginName) {
		const version = window[pluginName].version;
		const $el = jQuery(`table.plugins tr[data-slug="${pluginName}"] .plugin-version-author-uri`);

		jQuery.getJSON(`https://wp-plugins.knowe.work/library/${pluginName}/version.meta.json`, function (data) {
			if (version !== data.latest) {
				// Update available
				$el.append(`
					<div>
						<strong style="color: red;">New version available:
						<a href="https://wp-plugins.knowe.work/library/${pluginName}/${pluginName}.${data.latest}.zip" target="_blank">${data.latest}</a>
						| <a href="https://wp-plugins.knowe.work/library/${pluginName}/CHANGELOG.html" target="_blank">Changelog</a>
						</strong>
					</div>
				`);
			}
		});
	};

	return {
		checkForUpdates
	};
})();
