<?php

namespace Rubicore\Core;

final class User_Node_Repository {

	public function get_by_id(int $user_id, ?int $node_id) : ?array
	{
		$user_node_table = Db_Helper::table('user_node');
		$node_table = Db_Helper::table('node');

		return is_null($node_id) ?
			Db_Helper::get_rows("
			SELECT * FROM {$user_node_table} AS us
			INNER JOIN {$node_table} AS n
			ON n.id = us.node_id
			WHERE us.user_id = %d
		", [$user_id]) :
		Db_Helper::get_rows("
			SELECT * FROM {$user_node_table} AS us
			INNER JOIN {$node_table} AS n
			ON n.id = us.node_id
			WHERE us.user_id = %d
			AND us.node_id = %d
		", [$user_id, $node_id]);
	}


	public function add(int $user_id, int $node_id, bool $main) : void
	{
		Db_Helper::insert('user_node', array(
			'user_id' => $user_id,
			'node_id' => $node_id,
			'main' => $main
		), ['%d', '%d', '%d']);
	}

	public function remove(int $user_id, int $node_id) : void
	{
		Db_Helper::delete('user_node', array(
			'user_id' => $user_id,
			'node_id' => $node_id
		), ['%d', '%d']);
	}
}
