<?php

namespace Rubicore\Core;

final class Media_Query extends Query_Builder_Helper {

	public static array $fields = array(
		array(
			'key' => 'title',
			'internal_key' => 'post_title',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'filename',
			'internal_key' => 'post_content',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'description',
			'internal_key' => 'post_excerpt',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => false,
			'searchable' => true,
			'sortable' => false
		),

		array(
			'key' => 'publishedDate',
			'internal_key' => 'post_date',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => false,
			'searchable' => false,
			'sortable' => true
		),

		array(
			'key' => 'mimeType',
			'internal_key' => 'post_mime_type',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		)
	);

	public static function get_args() {
		return Query_Helper::generate_args(self::$fields);
	}
}
