<?php

namespace Rubicore\Core;

final class Post_Node_Repository
{
	private string $post_node_table;

	function __construct()
	{
		$this->post_node_table = Db_Helper::table('post_node');
	}

	public function get_by_post_id(int $post_id): array
	{
		return Db_Helper::get_rows("SELECT * FROM {$this->post_node_table} AS p WHERE p.post_id = %d", [$post_id]);
	}

	public function add(int $post_id, int $node_id): void
	{
		Db_Helper::insert('post_node', array(
			'post_id' => $post_id,
			'node_id' => $node_id
		), ['%d', '%d', '%d']);
	}

	public function remove(int $post_id, int $node_id): void
	{
		Db_Helper::delete('post_node', array(
			'post_id' => $post_id,
			'node_id' => $node_id
		), ['%d', '%d']);
	}

	public function remove_all(int $post_id): void
	{
		Db_Helper::delete('post_node', array(
			'post_id' => $post_id
		), ['%d']);
	}
}
