<?php

namespace Rubicore\Core;

final class Posttype_Installer
{

	public static function create_default_post_types() : void
	{

		$post_types = [
			['key' => 'page', 'label_s' => 'Sida', 'label_p' => 'Sidor'],
			['key' => 'news', 'label_s' => 'Nyhet', 'label_p' => 'Nyheter'],
			['key' => 'pinned-news', 'label_s' => 'Pinnad Nyhet', 'label_p' => 'Pinnade Nyheter'],
			['key' => 'info', 'label_s' => 'Information', 'label_p' => 'Information'],
			['key' => 'info-important', 'label_s' => 'Viktig Information', 'label_p' => 'Viktig Information'],
			['key' => 'alert', 'label_s' => 'Kris', 'label_p' => 'Kris'],
			['key' => 'advertisment', 'label_s' => 'Reklam', 'label_p' => 'Reklam'],
			['key' => 'givetake', 'label_s' => 'Get & Ta', 'label_p' => 'Get & Ta'],
			['key' => 'course', 'label_s' => 'Kurs', 'label_p' => 'Kurser']
		];

		foreach ($post_types as $post_type) {
			register_post_type($post_type['key'], [
				'labels' => [
					'name' => $post_type['label_p'],
					'singular_name' => $post_type['label_s'],
				],
				'public' => true,
				'has_archive' => true
			]);
		}
	}

}
