<?php

namespace Rubicore\Core;

final class Format_Helper {

	private static function find_and_add(&$children, $page) {
		foreach ($children as &$node) {
			if ($node->id === $page->parent) {
				$node->children = array(...$node->children, $page);

				unset($node);
				continue;
			}

			self::find_and_add($node->children, $page);
			unset($node);
		}
	}

	public static function flat_to_tree($arr) {
		$final = array();


		foreach($arr as $item) {
			if (!$item->parent) {
				array_push($final, $item);
				continue;
			}


			self::find_and_add($final, $item);
		}

		unset($item);

		return $final;
	}

	public static function bytes_to_mb(int $bytes) {
		return round(($bytes / 1024) / 1024, 2);
	}

	public static function b64url($content) {
		return str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($content));
	}

	public static function b64urldecode($content) {
		$text = str_replace(['-', '_'], ['+', '/'], $content);
		$len = strlen($text);
		$overflow = $len % 4;

		if ($overflow != 0) {
			$text = str_pad($text, $len + 4 - $overflow, "=");
		}

		return base64_decode($text);
	}


	public static function create_uuid($data = null) {
		$data = $data ?? random_bytes(16);
		assert(strlen($data) == 16);


		$data[6] = chr(ord($data[6]) & 0x0f | 0x40);
		$data[8] = chr(ord($data[8]) & 0x3f | 0x80);


		return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
	}

}
