<?php

namespace Rubicore\Core;

final class Post_Editor_Repository
{
	private string $post_editor_table;

	function __construct()
	{
		$this->post_editor_table = Db_Helper::table('post_editor');
	}

	public function get_by_user_id(int $user_id, string $type) : array
	{
		return Db_Helper::get_rows("
			SELECT * FROM {$this->post_editor_table} AS p
			WHERE p.user_id = %d
			AND p.type = %s", [$user_id, $type]);
	}

	public function get_by_post_id(int $post_id, string $type) : array
	{
		return Db_Helper::get_rows("
			SELECT * FROM {$this->post_editor_table} AS p
			WHERE p.post_id = %d
			AND p.type = %s", [$post_id, $type]);
	}

	public function add(int $post_id, int $user_id, string $type) : void
	{
		Db_Helper::insert('post_editor', array(
			'post_id' => $post_id,
			'user_id' => $user_id,
			'type' => $type
		), ['%d', '%d', '%s']);
	}

	public function remove(int $post_id, int $user_id, string $type) : void
	{
		Db_Helper::delete('post_editor', array(
			'post_id' => $post_id,
			'user_id' => $user_id,
			'type' => $type
		), ['%d', '%d', '%s']);
	}

	public function remove_all(int $post_id) : void
	{
		Db_Helper::delete('post_editor', array(
			'post_id' => $post_id
		), ['%d']);
	}
}
