<?php

namespace Rubicore\Core;

final class Db_Helper {

	public static function table($name):string {
		global $wpdb;
		return $wpdb->prefix . $name;
	}

	public static function last_query() {
		global $wpdb;
		echo $wpdb->last_query;
	}

	public static function prepare(string $sql, $args = array()) {
		global $wpdb;

		return $wpdb->prepare($sql, $args);
	}

	public static function escape_array($arr){
		global $wpdb;

		$escaped = array();

		foreach($arr as $k => $v){
			if(is_numeric($v)) {
				$escaped[] = $wpdb->prepare('%d', $v);
			} else {
				$escaped[] = $wpdb->prepare('%s', $v);
			}
		}

		return implode(',', $escaped);
	}

	public static function get_row($sql, $args = array(), $skip_prep = false, $output = OBJECT) {
		global $wpdb;

		if ($skip_prep) {
			$result = $wpdb->get_row($sql, $output);
		} else {
			$prep = $wpdb->prepare($sql, $args);

			$result = $wpdb->get_row($prep, $output);
		}

		if ($wpdb->last_error) {
			Response_Helper::die(wp_get_environment_type() === 'production' ?
				'You have an error in your SQL syntax' :
				$wpdb->last_error . ' QUERY: ' . $wpdb->last_query
			, 500);
		}

		return $result;
	}

	public static function get_rows($sql, $args = array(), $skip_prep = false, $output = OBJECT) {
		global $wpdb;

		if ($skip_prep) {
			$result = $wpdb->get_results($sql, $output);
		} else {
			$prep = $wpdb->prepare($sql, $args);

			$result = $wpdb->get_results($prep, $output);
		}

		if ($wpdb->last_error) {
			Response_Helper::die(wp_get_environment_type() === 'production' ?
				'You have an error in your SQL syntax' :
				$wpdb->last_error . ' QUERY: ' . $wpdb->last_query
			, 500);
		}

		return $result;
	}

	public static function insert($table_name, $data, $args = array()) {
		global $wpdb;

		$data = is_array($data) ? $data : (array) $data;

		$table = self::table($table_name);
		$wpdb->insert($table, $data, $args);

		if ($wpdb->last_error) {
			if (str_starts_with($wpdb->last_error, 'Duplicate entry')) {
				Response_Helper::die('Nyckeln eller IDt är upptaget.');
			}

			Response_Helper::die(wp_get_environment_type() === 'production' ?
				'You have an error in your SQL syntax' :
				$wpdb->last_error . ' QUERY: ' . $wpdb->last_query
			, 500);
		}

		return $wpdb->insert_id;
	}

	public static function update($table_name, $data, $where, $data_format = array()) {
		global $wpdb;
		$table = self::table($table_name);
		$result = $wpdb->update($table, $data, $where, $data_format);

		if ($wpdb->last_error) {
			if (str_starts_with($wpdb->last_error, 'Duplicate entry')) {
				Response_Helper::die('Nyckeln eller IDt är upptaget.');
			}

			Response_Helper::die(wp_get_environment_type() === 'production' ?
				'You have an error in your SQL syntax' :
				$wpdb->last_error . ' QUERY: ' . $wpdb->last_query
			, 500);
		}

		if ($result === false) {
			return false;
		 }

		 return true;
	}

	public static function delete($table_name, $where, $args = array()) {
		global $wpdb;
		$table = self::table($table_name);

		$result = $wpdb->delete($table, $where, $args);

		if ($wpdb->last_error) {
			Response_Helper::die(wp_get_environment_type() === 'production' ?
				'You have an error in your SQL syntax' :
				$wpdb->last_error . ' QUERY: ' . $wpdb->last_query
			, 500);
		}

		if ($result === false) {
			return false;
		}

		return true;
	}

	private static function create_table(string $name, string $body): void {
		global $wpdb;
		$table_name = self::table($name);
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE $table_name (
				$body
			) $charset_collate;";

		dbDelta($sql);
	}

}
