<?php

namespace Rubicore\Core;

final class Comment_Query extends Query_Builder_Helper
{

	public static array $fields = array(
		array(
			'key' => 'authorId',
			'internal_key' => 'user_id',
			'type' => Api_Helper::TYPE_INT,
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => false
		),

		array(
			'key' => 'postId',
			'internal_key' => 'comment_post_ID',
			'type' => Api_Helper::TYPE_INT,
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => false
		),

		array(
			'key' => 'publishedDate',
			'internal_key' => 'comment_date',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => false,
			'searchable' => false,
			'sortable' => true
		),

		array(
			'key' => 'content',
			'internal_key' => 'comment_content',
			'type' => Api_Helper::TYPE_STRING,
			'required' => false,
			'filterable' => false,
			'searchable' => true,
			'sortable' => false
		)
	);

	public static function get_args()
	{
		return Query_Helper::generate_args(self::$fields);
	}
}
