<?php

namespace Rubicore\Core;

class Entity_Helper {
	public function to_array() {
		return get_object_vars($this);
	}

	public function get_types() : array {
		$props = $this->to_array();
		$ret = [];

		foreach ($props as $key => $value) {
			$type = gettype($value);

			switch ($type) {
				case 'integer':
				case 'boolean':
					$ret[] = '%d';
					break;
				case 'double':
					$ret[] = '%f';
				case 'NULL':
					$ret[] = NULL;
					break;
				default:
					$ret[] = '%s';
					break;
			}
		}

		return $ret;
	}
}
