<?php if (!defined('ABSPATH')) {
	exit;
}

	add_filter('authenticate', function ($user) {
		// Only allow users with "administrator" role to access wp-admin

		if (empty($user->roles) || !in_array('administrator', $user->roles, true)) {
			$user = new WP_Error( 'authentication_failed', __('Access denied') );
		}

		return $user;
	}, PHP_INT_MAX, 3 );


	add_filter('wp_unique_post_slug', function ($slug, $post_ID, $post_status, $post_type, $post_parent) {
		global $wpdb, $wp_rewrite;

		//Don't touch hierarchical post types
		$hierarchical_post_types = get_post_types(array('hierarchical' => true));

		if (in_array($post_type, $hierarchical_post_types)) {
			return $slug;
		}

		if ('attachment' == $post_type) {
			return $slug;
		}

		$feeds = $wp_rewrite->feeds;

		if (!is_array($feeds)) {
			$feeds = array();
		}

		//Lets make sure the slug is really unique:
		$check_sql = "SELECT post_name FROM $wpdb->posts WHERE post_name = %s AND ID != %d LIMIT 1";
		$post_name_check = $wpdb->get_var($wpdb->prepare($check_sql, $slug, $post_ID));

		if ($post_name_check || in_array($slug, $feeds)) {
			$suffix = 2;

			do {
				$alt_post_name = substr($slug, 0, 200 - (strlen($suffix) + 1)) . "-$suffix";
				$post_name_check = $wpdb->get_var($wpdb->prepare($check_sql, $alt_post_name, $post_ID));
				$suffix++;
			} while ($post_name_check);

			$slug = $alt_post_name;
		}

		return $slug;
	}, 10, 5);
