<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore Core
Plugin URI:
Description: Core plugin for Rubicore framework
Version: 2.1.0
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: Rubicore
*/

define('RUBICORE_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore-core');
define('RUBICORE_TOKEN_TIME_API', 31556926); // One year
define('RUBICORE_TOKEN_TIME_WEB', 10 * 60 * 60);
// TODO: Disable rest-routes annat än rubicore
// TODO: Flytta till "säkert" ställe
// TODO: Lägg till "in" property på alla args-scheman

define('RUBICORE_SECRET', 'EsInVzZXJJRCI6MTY5MSwic2l0ZUlEIjoxLCJ');
ini_set('html_errors', false);
global $wpdb;
$wpdb->suppress_errors = true;

include_once RUBICORE_ROOT_DIR . '/autoloader.php';
include_once RUBICORE_ROOT_DIR . '/main.php';

Rubicore\Core\Autoloader::register_autoloader(RUBICORE_ROOT_DIR, 'Rubicore\\Core\\');

new Rubicore\Core\Main();
Rubicore\Core\Update_Helper::register_plugin('rubicore-core');

add_action('init', function () {
	do_action('rubicore_init');
});

add_action('admin_menu', function () {
	Rubicore\Core\Ui_Helper::setup_menu();

	do_action('rubicore_admin_menu');
});

add_action('admin_init', function () {
	if (!wp_doing_ajax()) {
		do_action('rubicore_admin_init');
	}
});

add_action('admin_enqueue_scripts', function () {
	wp_enqueue_script('rubicore-script', plugin_dir_url(__FILE__) . '/scripts/admin.js', array(), '1.0.0', true);
});

register_activation_hook(__FILE__, function () {
	$db_installer = new Rubicore\Core\Database_Installer();
	$db_installer->create_tables();

	$role_installer = new Rubicore\Core\Role_Installer();
	$role_installer->create_default_roles();
});

add_filter('authenticate', function ($user) {
	// Only allow users with "administrator" role to access wp-admin

	if (empty($user->roles) || !in_array('administrator', $user->roles, true)) {
		$user = new WP_Error( 'authentication_failed', __('Access denied') );
	}

	return $user;
}, PHP_INT_MAX, 3 );
