<?php

namespace Rubicore\Core;

final class Like_Repository
{

	private string $like_table;

	function __construct()
	{
		$this->like_table = Db_Helper::table('like');
	}

	public function get(\WP_REST_Request $req): array
	{
		$q = new Query_Builder_Helper($req, Like_Query::$fields);
		$where = "";
		$where = Query_Helper::add_where($q->filter_query, $where, "AND", $q->filter_query);
		$where = Query_Helper::add_where($q->search_query, $where, "AND", $q->search_query);

		$count_query = Query_Helper::get_count("FROM $this->like_table AS l $where");
		$total_count = Db_Helper::get_row($count_query)->num_rows;
		Response_Helper::set_pagination_total_header($total_count);

		$main_query = "SELECT * FROM $this->like_table AS l $where $q->order_by_query $q->limit_query";

		return Db_Helper::get_rows($main_query);
	}

	public function get_by_id(int $id): ?object
	{
		return Db_Helper::get_row("SELECT * FROM $this->like_table AS l WHERE l.id = %d", [$id]);
	}

	public function create(Like_Entity $entity): int
	{
		return Db_Helper::insert('like', $entity->to_array(), $entity->get_types());
	}

	public function update(int $id, string $type): bool
	{
		return Db_Helper::update('like', array('type' => $type), array('id' => $id), ['%s']);
	}

	public function delete(int $id) : bool
	{
		return Db_Helper::delete('like', array('id' => $id), ['%d']);
	}
}
