<?php

namespace Rubicore\Core;

final class Update_Helper
{
	public static function register_plugin(string $name) : void
	{
		add_action('admin_head', function () use($name) {
			$plugin_data = get_plugin_data(__FILE__);
			$data = json_encode(array(
				'version' => "{$plugin_data['Version']}"
			));

			$script = "
				<script>
					window['{$name}'] = {$data};
					jQuery(document).ready(function () {
						rubicore.version.checkForUpdates('{$name}');
					});
				</script>
			";

			echo $script;
		});
	}
}
