<?php

namespace Rubicore\Core;
use \WP_REST_Request, \WP_User;

final class User_Controller {

	function __construct () {
		$this->routes();
	}


	private function routes() : void {
		$api = new Api_Helper('rubicore/core/v1');


		$api->add_route('user', 'GET', function (WP_REST_Request $req, WP_User $user) : array {
			User_Helper::allowed_to('user_list', $user, $req->get_param('id'));

			$repo = new User_Repository();
			$users = $repo->get($req);

			return array_map(function($user) : User_Model {
				return  User_Transformer::transform_out($user);
			}, $users);
		}, array(
			'args' => array_merge(
				User_Query::get_args(),
				Query_Helper::get_pagination_args()
			)
		));



		$api->add_route('user/(?P<user_id>[^/]+?)', 'GET', function (WP_REST_Request $req, WP_User $user) : User_Model {
			User_Helper::allowed_to('user_get', $user, $req->get_param('user_id'));

			$user_repo = new User_Repository();
			$user = $user_repo->get_by_id($req->get_param('user_id'));

			if (!$user) {
				Response_Helper::not_found('No user found with provided id.');
			}

			return User_Transformer::transform_out($user);
		}, array(
			'args' => array(
				'user_id' => array(
					'type' => Api_Helper::TYPE_INT,
					'minimum' => 1
				)
			)
		));



		$api->add_route('user/(?P<user_id>\d+)', 'PUT', function (WP_REST_Request $req, WP_User $user) : void {
			User_Helper::allowed_to('user_edit', $user, $req->get_param('user_id'));

			$repo = new User_Repository();
			$body = Request_Helper::get_body($req);

			if ($body->meta) {
				$repo->update_meta($req->get_param('user_id'), User_Transformer::meta_transform_in($body->meta));
			}
		}, array(
			'args' => array(
				'user_id' => array('type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1)
			)
		));

	}
}
