<?php

namespace Rubicore\Core;

final class Node_Transformer {

	public static function transform_out($data) : Node_Model {
		$model = new Node_Model();

		$model->id = $data->id;
		$model->name = $data->name;
		$model->parent = $data->parent;
		$model->value = $data->value;

		return $model;
	}

	public static function transform_in(object $data) : Node_Entity {
		$model = new Node_Entity();

		$model->id = $data->id && null;
		$model->parent = $data->parent ? intval($data->parent) : null;

		// TODO: Casta inval() på alla inparams som är integers
		$model->name = $data->name;
		$model->value = $data->value;
		$model->ref = $data->ref;

		return $model;
	}

}
