<?php

namespace Rubicore\Core;

use WP_User;

final class Role_Repository {

	function __construct () {

	}

	public function get_by_key(string $key) : ?object {
		$roles = $this->get();

		$ret = null;

		foreach($roles as $role) {
			if ($role->key == $key) {
				$ret = $role;
				break;
			}
		}

		return $ret;
	}

	public function get(?int $user_id = null) : array {
		$all_roles = wp_roles()->roles;
		$ret = [];

		if ($user_id) {
			$user_roles = get_userdata($user_id)->roles;

			foreach ($all_roles as $key => $role) {
				if (in_array($key, $user_roles)) {
					$obj = new \stdClass();
					$obj->key = $key;
					$obj->name = $role['name'];

					$ret[] = $obj;
				}
			}

			return $ret;
		}

		foreach ($all_roles as $key => $role) {
			$obj = new \stdClass();
			$obj->key = $key;
			$obj->name = $role['name'];

			$ret[] = $obj;
		}

		return $ret;
	}


	public function create(string $name) : void {
		$key = sanitize_title($name);

		add_role($key, $name, []);
	}


	public function delete(string $key) : void {
		remove_role($key);
	}

}
