<?php

namespace Rubicore\Core;

final class Link_Repository {

	private string $link_table;
	private string $link_node_table;
	private string $user_link_table;

	function __construct () {
		$this->link_table = Db_Helper::table('link');
		$this->link_node_table = Db_Helper::table('link_node');
		$this->user_link_table = Db_Helper::table('user_link');
	}

	public function get(\WP_REST_Request $req, ?int $user_id = null) : array {
		$q = new Query_Builder_Helper($req, Link_Query::$fields);
		$where = "";
		$where = Query_Helper::add_where($q->filter_query, $where, "AND", $q->filter_query);
		$where = Query_Helper::add_where($q->search_query, $where, "AND", $q->search_query);
		$where = Query_Helper::add_where(!$user_id, $where, "AND", "l.public = true");
		$where = Query_Helper::add_where($user_id, $where, "AND", Db_Helper::prepare("
			EXISTS (
				SELECT * FROM $this->user_link_table AS ul
				WHERE ul.link_id = l.id
				AND ul.user_id = %d
			)
		", [$user_id]));

		$count_query = Query_Helper::get_count("FROM $this->link_table AS l $where");
		$total_count = Db_Helper::get_row($count_query)->num_rows;
		Response_Helper::set_pagination_total_header($total_count);

		$main_query = "SELECT * FROM $this->link_table AS l $where $q->order_by_query $q->limit_query";

		return Db_Helper::get_rows($main_query);
	}

	public function get_by_id(int $id) : ?object {
		return Db_Helper::get_row("SELECT * FROM $this->link_table AS l WHERE l.id = %d", [$id]);
	}

	public function get_nodes(array $links) : array {
		if (count($links) === 0) {
			return [];
		}

		$link_ids = array_map(fn($val) : int => intval($val->id), $links);
		$link_ids = Db_Helper::escape_array($link_ids);

		return Db_Helper::get_rows("SELECT * FROM $this->link_node_table AS lci WHERE lci.link_id IN ($link_ids)");
	}

	public function delete_link(int $id) : void {
		Db_Helper::delete('link', array('id' => $id), ['%d']);
		Db_Helper::delete('user_link', array('link_id' => $id), ['%d']);
		Db_Helper::delete('link_node', array('link_id' => $id), ['%d']);
	}

	public function create(Link_Entity $entity) : int {
		return Db_Helper::insert('link', $entity->to_array(), $entity->get_types());
	}

	public function update_link(int $id, Link_Entity $entity) : bool {
		return Db_Helper::update('link', $entity->to_array(), array('id'=> $id), $entity->get_types());
	}

	public function add_link_to_node(array $data) : int {
		return Db_Helper::insert('link_node', $data, ['%d', '%d']);
	}

	public function add_link_to_user(array $data) : int {
		return Db_Helper::insert('user_link', array(
			'user_id' => $data['user_id'],
			'link_id' => $data['link_id'],
			'sort' => -1
		), ['%d', '%d', '%d']);
	}
}
