<?php

namespace Rubicore\Core;

final class Category_Node_Repository {

	public function get_by_node_id (int $node_id) : ?array {
		$category_node_table = Db_Helper::table('category_node');

		return Db_Helper::get_rows("SELECT * FROM {$category_node_table} WHERE node_id = %d", [$node_id]);
	}

	public function add(int $category_id, int $node_id) : void {
		Db_Helper::insert('category_node', array(
			'category_id' => $category_id,
			'node_id' => $node_id
		), ['%d', '%d']);
	}

	public function remove(int $category_id, int $node_id) : void {
		Db_Helper::delete('category_node', array(
			'category_id' => $category_id,
			'node_id' => $node_id
		), ['%d', '%d']);
	}

}
