<?php

namespace Rubicore\Core;

final class Response_Helper {

	public static function set_pagination_total_header(int $count) : void {
		header("X-Pagination-Total: $count");
	}

	public static function die(String $msg, Int $code = 400) {
		throw new \Exception($msg, $code);
	}

	public static function bad(String $msg = 'Bad request') {
		self::die($msg, 400);
	}

	public static function not_authenticated(String $msg) {
		self::die($msg, 401);
	}

	public static function not_authorized(String $msg) {
		self::die($msg, 403);
	}

	public static function not_found(String $msg) {
		self::die($msg, 404);
	}
}
