<?php

namespace Rubicore\Core;

class Query_Builder_Helper{

	public string $search_query;
	public string $limit_query;
	public string $order_by_query;
	public string $filter_query;


	function __construct(\WP_REST_Request $req, array $fields) {
		$search_fields = Query_Helper::get_searchables($fields);
		$filter_fields = Query_Helper::get_filterables($fields);
		$sort_fields = Query_Helper::get_sortables($fields);

		$this->search_query = Query_Helper::get_search_query($req->get_param('search'), $search_fields);
		$this->filter_query = Query_Helper::get_filter_query($req->get_query_params(), $filter_fields);
		$this->order_by_query = Query_Helper::get_sort_query($req->get_param('sort'), $sort_fields);
		$this->limit_query = Query_Helper::get_limit_query($req);
	}
}
