<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class User_Node_Controller
{

	function __construct()
	{
		$this->routes();
	}


	private function routes(): void
	{
		$api = new Api_Helper('rubicore/core/v1');


		// add NODE
		$api->add_route('user/(?P<user_id>\d+)/node/(?P<node_id>\d+)', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			User_Helper::allowed_to('user_node_add', $user, $req->get_param('user_id'));

			$user = (new User_Repository())->get_by_id($req->get_param('user_id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$node = (new Node_Repository())->get_by_id($req->get_param('node_id'));
			if (!$node) {
				Response_Helper::not_found("No node found with provided id.");
			}

			$user_node_repo = new User_Node_Repository();
			$user_node_repo->add($req->get_param('user_id'), $req->get_param('node_id'), $req->get_param('main'));
		}, array(
			'args' => array(
				'main' => array('type' => Api_Helper::TYPE_BOOL, 'required' => false, 'default' => false),
				'user_id' => array('type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1),
				'node_id' => array('type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1)
			)
		));



		// remove NODE
		$api->add_route('user/(?P<user_id>\d+)/node/(?P<node_id>\d+)', 'DELETE', function (WP_REST_Request $req, WP_User $user): void {
			User_Helper::allowed_to('user_node_remove', $user, $req->get_param('user_id'));

			$user = (new User_Repository())->get_by_id($req->get_param('user_id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$node = (new Node_Repository())->get_by_id($req->get_param('node_id'));
			if (!$node) {
				Response_Helper::not_found("No node found with provided id.");
			}

			(new User_Node_Repository())->remove($req->get_param('user_id'), $req->get_param('node_id'));
		}, array(
			'args' => array(
				'user_id' => array('type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1),
				'node_id' => array('type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1)
			)
		));
	}
}
