<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class User_Link_Controller
{

	function __construct()
	{
		$this->routes();
	}


	private function routes(): void
	{
		$api = new Api_Helper('rubicore/core/v1');


		// add LINK
		$api->add_route('user/(?P<id>\d+)/link/(?P<link_id>\d+)', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			$user = (new User_Repository())->get_by_id($req->get_param('id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}


			$link = (new Link_Repository())->get_by_id($req->get_param('link_id'));
			if (!$link) {
				Response_Helper::not_found("No link found with provided id.");
			}

			(new User_Link_Repository())->add($req->get_param('id'), $req->get_param('link_id'));
		});



		// remove LINK
		$api->add_route('user/(?P<id>\d+)/link/(?P<link_id>\d+)', 'DELETE', function (WP_REST_Request $req, WP_User $user): void {
			$user = (new User_Repository())->get_by_id($req->get_param('id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}


			$link = (new Link_Repository())->get_by_id($req->get_param('link_id'));
			if (!$link) {
				Response_Helper::not_found("No link found with provided id.");
			}

			(new User_Link_Repository())->remove($req->get_param('id'), $req->get_param('link_id'));
		});
	}
}
