<?php

namespace Rubicore\Core;
use \WP_REST_Request, \WP_User;

final class Role_Controller {

	function __construct () {
		$this->routes();
	}


	private function routes() : void {
		$api = new Api_Helper('rubicore/core/v1');


		$api->add_route('role', 'GET', function (WP_REST_Request $req, WP_User $user) : array {
			$role_repo = new Role_Repository();
			$user_id = $req->get_param('userId');

			User_Helper::allowed_to('role_list', $user, $user_id);

			if ($user_id && !(new User_Repository())->get_by_id($user_id)) {
				Response_Helper::not_found('No user found with provided id.');
			}

			return array_map(fn($val) : Role_Model => Role_Transformer::transform_out($val), $role_repo->get($user_id));
		}, array(
			'args' => array(
				'userId' => array(
					'type' => Api_Helper::TYPE_INT,
					'required' => false,
					'minimum' => 1
				)
			)
		));


		$api->add_route('role/(?P<key>[^/]+?)', 'GET', function (WP_REST_Request $req, WP_User $user) : Role_Model {
			User_Helper::allowed_to('role_get', $user);

			$role_repo = new Role_Repository();

			$role = $role_repo->get_by_key($req->get_param('key'));

			if (!$role) {
				Response_Helper::not_found('No role found with provided key.');
			}

			return Role_Transformer::transform_out($role);
		});



		$api->add_route('role', 'POST', function (WP_REST_Request $req, WP_User $user) : void {
			User_Helper::allowed_to('role_create', $user);

			$repo = new Role_Repository();

			$repo->create($req->get_param('name'));
		}, array(
			'args' => array(
				'name' => array('type' => Api_Helper::TYPE_STRING, 'required' => true)
			)
		));



		$api->add_route('role/(?P<key>[^/]+?)', 'DELETE', function (WP_REST_Request $req, WP_User $user) : void {
			User_Helper::allowed_to('role_delete', $user);

			$role_repo = new Role_Repository();
			$role = $role_repo->get_by_key($req->get_param('key'));

			if (!$role) {
				Response_Helper::not_found('No role found with provided key.');
			}

			$role_repo->delete($req->get_param('key'));
		});



		$api->add_route('role/(?P<key>[^/]+?)/capability/(?P<cap_key>[^/]+?)', 'POST', function (WP_REST_Request $req, WP_User $user) : void {
			User_Helper::allowed_to('role_capability_add', $user);

			$role = (new Role_Repository())->get_by_key($req->get_param('key'));
			if (!$role) {
				Response_Helper::not_found('No role found with provided key.');
			}

			$capability = (new Capability_Repository())->get_by_key($req->get_param('cap_key'));
			if (!$capability) {
				Response_Helper::not_found('No role found with provided key.');
			}

			$role_capability_repo = new Role_Capability_Repository();
			$role_capability_repo->add($req->get_param('key'), $req->get_param('cap_key'), $req->get_param('value'));
		}, array(
			'args' => array(
				'value' => array('type' => Api_Helper::TYPE_BOOL, 'required' => true)
			)
		));



		$api->add_route('role/(?P<key>[^/]+?)/capability/(?P<cap_key>[^/]+?)', 'DELETE', function (WP_REST_Request $req, WP_User $user) : void {
			User_Helper::allowed_to('role_capability_remove', $user);

			$role = (new Role_Repository())->get_by_key($req->get_param('key'));
			if (!$role) {
				Response_Helper::not_found('No role found with provided key.');
			}

			$capability = (new Capability_Repository())->get_by_key($req->get_param('cap_key'));
			if (!$capability) {
				Response_Helper::not_found('No role found with provided key.');
			}

			$role_capability_repo = new Role_Capability_Repository();
			$role_capability_repo->remove($req->get_param('key'), $req->get_param('cap_key'));
		});
	}
}
