<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class Course_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes(): void
	{
		$api = new Api_Helper('rubicore/core/v1');

		$api->add_route('course-attendee/(?P<course_id>[^/]+?)', 'GET', function (WP_REST_Request $req, WP_User $user): array {
			User_Helper::allowed_to('like_list', $user);
			$course_repo = new Course_Repository();
			$user_repo = new User_Repository();

			$course_attendees = $course_repo->get_by_id($req->get_param('course_id'));

			if (!$course_attendees) {
				Response_Helper::not_found("No course found with provided id.");
			}

			return array_map(function($attendee) use ($user_repo) : Course_Attendee_Model {
				$attendee->user = $user_repo->get_by_id($attendee->user_id);

				return Course_Transformer::transform_attendee_out($attendee);
			}, $course_attendees);
		}, array(
			'args' => array(
				'course_id' => array(
					'type' => Api_Helper::TYPE_INT,
					'minimum' => 1
				)
			)
		));

	}
}
