<?php

namespace Rubicore\Core;

final class Post_Transformer {

	private static function transform_meta_out(array $data) : Post_Meta_Model
	{
		$model = new Post_Meta_Model();

		$model->blurbs = $data['blurbs'] ?? null;
		$model->info = $data['info'] ?? null;
		$model->contact = $data['contact'] ?? null;
		$model->unpublishedDate = $data['unpublishedDate'] ?? null;
		$model->authoredDate = $data['authoredDate'] ?? null;
		$model->pseudoAuthor = $data['pseudoAuthor'] ?? null;
		$model->courseStartDate = $data['courseStartDate'] ?? null;
		$model->courseEndDate = $data['courseEndDate'] ?? null;
		$model->courseCancellationDate = $data['courseCancellationDate'] ?? null;
		$model->coursePlace = $data['coursePlace'] ?? null;
		$model->courseNumberOfAttendees = $data['courseNumberOfAttendees'] ?? null;
		$model->courseBookable = $data['courseBookable'] ?? null;
		$model->courseAttendeeInformation = $data['courseAttendeeInformation'] ?? null;

		return $model;
	}

	public static function transform_out(object $data) : Post_Model
	{
		$model = new Post_Model();

		$model->id = $data->ID;
		$model->title = $data->post_title;
		$model->content = $data->post_content ?? null;
		$model->excerpt = $data->post_excerpt;
		$model->publishedDate = $data->post_date;
		$model->updatedDate = $data->post_modified;
		$model->status = $data->post_status;
		$model->slug = $data->post_name;
		$model->allowComments = $data->comment_status == 'open';
		$model->commentCount = $data->comment_count;
		$model->type = $data->post_type;
		$model->order = $data->menu_order;
		$model->parent = $data->post_parent;
		$model->author = $data->user ? User_Transformer::transform_list_out($data->user) : null;
		$model->meta = self::transform_meta_out($data->meta);
		$model->media = $data->media ? Media_Transformer::transform_out($data->media) : null;
		$model->categoryIds = $data->category_ids ?: [];
		$model->nodeIds = $data->node_ids ?: [];
		$model->userIds = $data->user_ids ?: [];
		$model->editorIds = $data->editor_ids ?: [];

		return $model;
	}

	public static function transform_in(object $data) : Post_Entity {
		$entity = new Post_Entity();

		$entity->post_author = $data->authorId;
		$entity->post_date = $data->publishedDate ?? null;
		$entity->post_title = $data->title;
		$entity->post_content = $data->content;
		$entity->post_excerpt = $data->excerpt;
		$entity->post_type = $data->type;
		$entity->post_status = $data->status ?? 'publish';
		$entity->comment_status = $data->allowComments ? 'open' : 'closed';
		$entity->post_name = $data->slug ?? null;
		$entity->post_parent = $data->parentId ?? 0;
		$entity->menu_order = $data->order ?? 0;

		return $entity;
	}
}
