<?php

namespace Rubicore\Core;

final class Like_Transformer
{

	public static function transform_in(array $data): Like_Entity
	{
		$entity = new Like_Entity();

		$entity->user_id = $data['user_id'] ?? null;
		$entity->post_id = $data['post_id'] ?? null;
		$entity->type = $data['type'];

		return $entity;
	}

	public static function transform_out(object $data): Like_Model
	{
		$model = new Like_Model();

		$model->id = $data->id;
		$model->postId = $data->post_id;
		$model->type = $data->type;
		$model->publishedAt = $data->created;
		$model->author = $data->user ? User_Transformer::transform_list_out($data->user) : null;

		return $model;
	}
}
