<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore Core
Plugin URI:
Description: Core plugin for Rubicore framework
Version: 1.1.0
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: Rubicore
*/

define('RUBICORE_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore');
define('RUBICORE_TOKEN_TIME_API', 31556926); // One year
define('RUBICORE_TOKEN_TIME_WEB', 10 * 60 * 60);

// TODO: Flytta till "säkert" ställe
define('RUBICORE_SECRET', 'EsInVzZXJJRCI6MTY5MSwic2l0ZUlEIjoxLCJ');
ini_set('html_errors', false);
global $wpdb;
$wpdb->suppress_errors = true;

include_once RUBICORE_ROOT_DIR . '/autoloader.php';
include_once RUBICORE_ROOT_DIR . '/main.php';

Rubicore\Core\Autoloader::register_autoloader(RUBICORE_ROOT_DIR, 'Rubicore\\Core\\');

new Rubicore\Core\Main();

add_action('init', function () {
	do_action('rubicore_init');
});

add_action('admin_menu', function () {
	Rubicore\Core\Ui_Helper::setup_menu();

	do_action('rubicore_admin_menu');
});

add_action('admin_init', function () {
	do_action('rubicore_admin_init');
});

add_action('plugins_loaded', function () {

});

add_action('phpmailer_init', function (PHPMailer\PHPMailer\PHPMailer $mailer) {
	$mailer->IsSMTP();
	$mailer->Host = "smtp.gmail.com";
	$mailer->Port = 465;
	$mailer->SMTPDebug = PHPMailer\PHPMailer\SMTP::DEBUG_SERVER;
	$mailer->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_SMTPS;
	$mailer->SMTPAuth = true;
	$mailer->SMTPDebug = 0;
	$mailer->CharSet  = "utf-8";

	$mailer->Username = constant('RUBICORE_SMTP_USERNAME');
	$mailer->Password = constant('RUBICORE_SMTP_PASSWORD');
	$mailer->setFrom('rubicore.info@gmail.com', 'Henrik Peszlen');

	return $mailer;
});

register_activation_hook(__FILE__, function () {
	$db_installer = new Rubicore\Core\Database_Installer();
	$db_installer->create_tables();
});
