<?php

namespace Rubicore\Core;

final class Node_Repository {
	private string $node_table;
	private string $category_node_table;
	private string $user_node_table;

	function __construct () {
		$this->node_table = Db_Helper::table('node');
		$this->category_node_table = Db_Helper::table('category_node');
		$this->user_node_table = Db_Helper::table('user_node');
		$this->post_node_table = Db_Helper::table('post_node');
	}

	public function get_by_id(int $id) : ?object {
		return Db_Helper::get_row("SELECT * FROM $this->node_table AS l WHERE l.id = %d", [$id]);
	}

	public function get_by_value(string $value) : ?object {
		return Db_Helper::get_row("SELECT * FROM $this->node_table AS l WHERE l.value = %s", [$value]);
	}

	public function get(\WP_REST_Request $req, array $filter = []) : array {
		$q = new Query_Builder_Helper($req, Node_Query::$fields);
		$where = "";

		$where = Query_Helper::add_where($q->filter_query, $where, "AND", $q->filter_query);
		$where = Query_Helper::add_where($q->search_query, $where, "AND", $q->search_query);

		$where = Query_Helper::add_where($filter['userId'], $where, "AND", Db_Helper::prepare("
			EXISTS (
				SELECT * FROM $this->user_node_table AS uci
				WHERE uci.node_id = ci.id
				AND uci.user_id = %d
			)
		", [$filter['userId']]));

		$where = Query_Helper::add_where($filter['categoryId'], $where, "AND", Db_Helper::prepare("
			EXISTS (
				SELECT * FROM $this->category_node_table AS cr
				WHERE cr.node_id = ci.id
				AND cr.category_id = %d
			)
		", [$filter['categoryId']]));

		$where = Query_Helper::add_where($filter['postId'], $where, "AND", Db_Helper::prepare("
			EXISTS (
				SELECT * FROM $this->post_node_table AS cr
				WHERE cr.node_id = ci.id
				AND cr.post_id = %d
			)
		", [$filter['postId']]));

		$count_query = Query_Helper::get_count("FROM $this->node_table AS ci $where");
		$total_count = Db_Helper::get_row($count_query)->num_rows;
		Response_Helper::set_pagination_total_header($total_count);


		$main_query = "SELECT * FROM $this->node_table AS ci $where $q->order_by_query $q->limit_query";

		$rows = Db_Helper::get_rows($main_query);

		return $rows;
	}

	public function create(Node_Entity $entity) : int {
		return Db_Helper::insert('node', $entity->to_array(), $entity->get_types());
	}

	public function update(int $id, Node_Entity $entity) : bool {
		return Db_Helper::update('node', $entity->to_array(), array('id' => $id), $entity->get_types());
	}

	public function delete(int $id) : void {
		Db_Helper::delete('node', array('id' => $id), ['%d']);
		Db_Helper::delete('category_node', array('node_id' => $id), ['%d']);
		Db_Helper::delete('user_node', array('node_id' => $id), ['%d']);
	}
}
