<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class User_Role_Controller
{

	function __construct()
	{
		$this->routes();
	}


	private function routes(): void
	{
		$api = new Api_Helper('rubicore/v1');


		// add ROLE
		$api->add_route('user/(?P<id>\d+)/role/(?P<key>[^/]+?)', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			$user = (new User_Repository())->get_by_id($req->get_param('id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}


			$role = (new Role_Repository())->get_by_key($req->get_param('key'));
			if (!$role) {
				Response_Helper::not_found("No role found with provided key.");
			}

			(new User_Role_Repository())->add($req->get_param('id'), $req->get_param('key'));
		});



		// remove ROLE
		$api->add_route('user/(?P<id>\d+)/role/(?P<key>[^/]+?)', 'DELETE', function (WP_REST_Request $req, WP_User $user) {
			$user = (new User_Repository())->get_by_id($req->get_param('id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}


			$role = (new Role_Repository())->get_by_key($req->get_param('key'));
			if (!$role) {
				Response_Helper::not_found("No role found with provided key.");
			}

			(new User_Role_Repository())->remove($req->get_param('id'), $req->get_param('key'));
		});
	}
}
