<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class User_Category_Controller
{

	function __construct()
	{
		$this->routes();
	}


	private function routes(): void
	{
		$api = new Api_Helper('rubicore/v1');


		$api->add_route('user/(?P<user_id>\d+)/category/(?P<category_id>\d+)', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			$user = (new User_Repository())->get_by_id($req->get_param('user_id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$category = (new Category_Repository())->get_by_id($req->get_param('category_id'));
			if (!$category) {
				Response_Helper::not_found("No category found with provided id.");
			}

			$user_category_repo = new User_Category_Repository();
			$user_category_repo->add($req->get_param('user_id'), $req->get_param('category_id'));
		}, array(
			'args' => array(
				'user_id' => array('type' => 'integer', 'required' => true, 'minumum' => 1),
				'category_id' => array('type' => 'integer', 'required' => true, 'minumum' => 1)
			)
		));


		$api->add_route('user/(?P<user_id>\d+)/category/(?P<category_id>\d+)', 'DELETE', function (WP_REST_Request $req, WP_User $user): void {
			$user = (new User_Repository())->get_by_id($req->get_param('user_id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$category = (new Category_Repository())->get_by_id($req->get_param('category_id'));
			if (!$category) {
				Response_Helper::not_found("No category found with provided id.");
			}

			(new User_Category_Repository())->remove($req->get_param('user_id'), $req->get_param('category_id'));
		}, array(
			'args' => array(
				'user_id' => array('type' => 'integer', 'required' => true, 'minumum' => 1),
				'category_id' => array('type' => 'integer', 'required' => true, 'minumum' => 1)
			)
		));


	}
}
