<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class User_Capability_Controller
{

	function __construct()
	{
		$this->routes();
	}


	private function routes(): void
	{
		$api = new Api_Helper('rubicore/v1');

		$api->add_route('user/(?P<user_id>\d+)/capability', 'GET', function (WP_REST_Request $req, WP_User $user): array {
			$user = (new User_Repository())->get_by_id($req->get_param('user_id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$capability_repo = new Capability_Repository();
			$user_capabilities = $capability_repo->get_for_user($req->get_param('user_id'));

			return array_map(fn($cap) : Capability_Model => Capability_Transformer::transform_out($cap), $user_capabilities);
		}, array(
			'args' => array(
				'user_id' => array('type' => 'integer', 'required' => true, 'minimum' => 1)
			)
		));


		$api->add_route('user/(?P<id>\d+)/capability/(?P<key>[^/]+?)', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			$user = (new User_Repository())->get_by_id($req->get_param('id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}


			$capability = (new Capability_Repository())->get_by_key($req->get_param('key'));
			if (!$capability) {
				Response_Helper::not_found("No capability found with provided key.");
			}

			(new User_Capability_Repository())->add($req->get_param('id'), $req->get_param('key'), $req->get_param('value'));
		}, array(
			'args' => array(
				'value' => array('type' => 'boolean', 'required' => true)
			)
		));


		$api->add_route('user/(?P<id>\d+)/capability/(?P<key>[^/]+?)', 'DELETE', function (WP_REST_Request $req, WP_User $user) {
			$user = (new User_Repository())->get_by_id($req->get_param('id'));
			if (!$user) {
				Response_Helper::not_found("No user found with provided id.");
			}


			$capability = (new Capability_Repository())->get_by_key($req->get_param('key'));
			if (!$capability) {
				Response_Helper::not_found("No capability found with provided key.");
			}

			(new User_Capability_Repository())->remove($req->get_param('id'), $req->get_param('key'));
		});
	}
}
