<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class Node_Controller {

	function __construct () {
		$this->routes();
	}

	private function routes() : void {
		$api = new Api_Helper('rubicore/v1');


		$api->add_route('node', 'GET', function (WP_REST_Request $req, WP_User $user) : array {
			$node_repo = new Node_Repository();
			$filter = array(
				'categoryId' => $req->get_param('categoryId'),
				'userId' => $req->get_param('userId'),
				'postId' => $req->get_param('postId')
			);

			$items = $node_repo->get($req, $filter);

			return array_map(fn($item) : Node_Model => Node_Transformer::transform_out($item), $items);
		}, array(
			'args' => array_merge(
				Node_Query::get_args(),
				Query_Helper::get_pagination_args(),
				array(
					'categoryId' => array('type' => 'integer', 'required' => false),
					'userId' => array('type' => 'integer', 'required' => false),
					'postId' => array('type' => 'integer', 'required' => false)
				)
			)
		));

		$api->add_route('node/(?P<id>[^/]+?)', 'GET', function (WP_REST_Request $req, WP_User $user) : Node_Model {
			$repo = new Node_Repository();
			$item = $repo->get_by_id($req->get_param('id'));

			if (!$item) {
				Response_Helper::not_found('No node found with provided id.');
			}

			return Node_Transformer::transform_out($item);
		});

		$api->add_route('node', 'POST', function (WP_REST_Request $req, WP_User $user) : int {
			$node_repo = new Node_Repository();
			$body = Request_Helper::get_body($req);

			return $node_repo->create(Node_Transformer::transform_in($body));
		}, array(
			'args' => array(
				'name' => array('type' => 'string', 'required' => false),
				'value' => array('type' => 'string', 'required' => false),
				'parent' => array('type' => 'integer', 'required' => false)
			)
		));

		$api->add_route('node/(?P<id>[^/]+?)', 'PUT', function (WP_REST_Request $req, WP_User $user) : void {
			$repo = new Node_Repository();
			$item = $repo->get_by_id($req->get_param('id'));

			if (!$item) {
				Response_Helper::not_found('No node found with provided id.');
			}

			$body = Request_Helper::get_body($req);
			$repo->update($req->get_param('id'), Node_Transformer::transform_in($body));
		}, array(
			'args' => array(
				'name' => array('type' => 'string', 'required' => false),
				'value' => array('type' => 'string', 'required' => false),
				'parent' => array('type' => 'integer', 'required' => false)
			)
		));

		$api->add_route('node/(?P<id>[^/]+?)', 'DELETE', function (WP_REST_Request $req, WP_User $user) : void {
			$repo = new Node_Repository();
			$item = $repo->get_by_id($req->get_param('id'));

			if (!$item) {
				Response_Helper::not_found('No node found with provided id.');
			}

			$repo->delete($req->get_param('id'));
		});

	}

}
