<?php

namespace Rubicore\Core;
use \WP_REST_Request, \WP_User;

final class Capability_Controller {

	function __construct () {
		$this->routes();
	}


	private function routes() : void {
		$api = new Api_Helper('rubicore/v1');

		$api->add_route('capability', 'GET', function (WP_REST_Request $req, WP_User $user) : array {
			User_Helper::allowed_to('capability_list', $user, $req->get_param('userId'));

			$repo = new Capability_Repository();
			$filter = array(
				'role' => $req->get_param('role')
			);

			$caps = $repo->get($filter);

			return array_map(fn($val) : Capability_Model => Capability_Transformer::transform_out($val), $caps);
		}, array(
			'args' => array(
				'role' => array('type' => 'string', 'required' => false),
			)
		));
	}

}
