<?php

namespace Rubicore\Core;

final class Post_Query extends Query_Builder_Helper {

	public static array $fields = array(
		array(
			'key' => 'authorId',
			'internal_key' => 'post_author',
			'type' => 'integer',
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => false
		),

		array(
			'key' => 'publishedDate',
			'internal_key' => 'post_date',
			'type' => 'string',
			'required' => false,
			'filterable' => false,
			'searchable' => false,
			'sortable' => true
		),

		array(
			'key' => 'content',
			'internal_key' => 'post_content',
			'type' => 'string',
			'required' => false,
			'filterable' => false,
			'searchable' => true,
			'sortable' => false
		),

		array(
			'key' => 'title',
			'internal_key' => 'post_title',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'excerpt',
			'internal_key' => 'post_excerpt',
			'type' => 'string',
			'required' => false,
			'filterable' => false,
			'searchable' => true,
			'sortable' => false
		),

		array(
			'key' => 'status',
			'internal_key' => 'post_status',
			'type' => ['null','string'],
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => true
		),

		array(
			'key' => 'allowComments',
			'internal_key' => 'comment_status',
			'type' => 'boolean',
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => false
		),

		array(
			'key' => 'type',
			'internal_key' => 'post_type',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => true
		),

		array(
			'key' => 'order',
			'internal_key' => 'menu_order',
			'type' => 'integer',
			'required' => false,
			'filterable' => false,
			'searchable' => false,
			'sortable' => true
		),

		array(
			'key' => 'parentId',
			'internal_key' => 'post_parent',
			'type' => 'integer',
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => false
		)
	);

	public static function get_args()
	{
		return Query_Helper::generate_args(self::$fields);
	}
}
