<?php

namespace Rubicore\Core;

final class Media_Query extends Query_Builder_Helper {

	function __construct(\WP_REST_Request $req) {
		parent::__construct($req, $this->search_fields, $this->filter_fields);
	}

	public static array $fields = array(
		array(
			'key' => 'title',
			'internal_key' => 'post_title',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'filename',
			'internal_key' => 'post_content',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'description',
			'internal_key' => 'post_excerpt',
			'type' => 'string',
			'required' => false,
			'filterable' => false,
			'searchable' => true,
			'sortable' => false
		),

		array(
			'key' => 'publishedDate',
			'internal_key' => 'post_date',
			'type' => 'string',
			'required' => false,
			'filterable' => false,
			'searchable' => false,
			'sortable' => true
		)
	);

	public static function get_args() {
		return Query_Helper::generate_args(self::$fields);
	}
}
