<?php

namespace Rubicore\Core;

final class Link_Query extends Query_Builder_Helper {

	public static array $fields = array(
		array(
			'key' => 'name',
			'internal_key' => 'name',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'shortDescription',
			'internal_key' => 'short_description',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => false
		),

		array(
			'key' => 'longDescription',
			'internal_key' => 'long_description',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => false
		),

		array(
			'key' => 'type',
			'internal_key' => 'type',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => true
		),

		array(
			'key' => 'url',
			'internal_key' => 'url',
			'type' => 'string',
			'required' => false,
			'filterable' => true,
			'searchable' => true,
			'sortable' => true
		),

		array(
			'key' => 'created',
			'internal_key' => 'created',
			'type' => 'string',
			'format' => 'date-time',
			'required' => false,
			'filterable' => true,
			'searchable' => false,
			'sortable' => true
		)
	);

	public static function get_args() {
		return Query_Helper::generate_args(self::$fields);
	}
}
