<?php

namespace Rubicore\Core;

final class Autoloader {

	public static function register_autoloader(string $root_dir, string $namespace) : void {

		spl_autoload_register(function ($className) use($root_dir, $namespace) {
			if (str_starts_with($className, $namespace)) {
				$className = str_replace($namespace, '', $className);
				preg_match('/[a-zA-Z]+$/i', $className, $matches, PREG_UNMATCHED_AS_NULL);
				$type = strtolower($matches[0]);
				$filename = str_replace('_', '-', $className);
				$filename = strtolower($filename) . '.php';
				preg_match('/^[a-zA-Z]+/i', $filename, $matches, PREG_UNMATCHED_AS_NULL);
				$object_name = $matches[0];

				switch ($type) {
					case 'controller':
						require_once "{$root_dir}/controllers/{$object_name}/{$filename}";
						break;
					case 'helper':
						require_once "{$root_dir}/helpers/{$filename}";
						break;
					case 'repository':
						require_once "{$root_dir}/repositories/{$object_name}/{$filename}";
						break;
					case 'transformer':
						require_once "{$root_dir}/transformers/{$filename}";
						break;
					case 'model':
						require_once "{$root_dir}/contracts/models/{$filename}";
						break;
					case 'entity':
						require_once "{$root_dir}/contracts/entities/{$filename}";
						break;
					case 'query':
						require_once "{$root_dir}/contracts/queries/{$filename}";
						break;
					case 'data':
						require_once "{$root_dir}/data/{$filename}";
						break;
					case 'installer':
						require_once "{$root_dir}/installers/{$filename}";
						break;
				}
			}
		});

	}
}
