<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore Alingsås Intranät
Plugin URI:
Description: Rubicore plugin for Alingsås municipality intranet.
Version: 0.3.0
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: Rubicore
*/


function RUBICORE_AlingsasIntranet_check_dependencies(): void
{
	if (!is_plugin_active('rubicore-core/rubicore-core.php') && current_user_can('activate_plugins')) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die('Sorry, but Rubicore Alingsås Intranet plugin requires the Rubicore Core plugin to be installed and active. <br><a href="' . admin_url('plugins.php') . '">&laquo; Return to Plugins</a>');
	}
}

register_activation_hook(__FILE__, 'RUBICORE_AlingsasIntranet_check_dependencies');

define('RUBICORE_ALINGSASINTRANET_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore-alingsas-intranet');

add_action('rubicore_init', function () {
	Rubicore\Core\Autoloader::register_autoloader(RUBICORE_ALINGSASINTRANET_ROOT_DIR, 'Rubicore\\AlingsasIntranet\\');

	new Rubicore\AlingsasIntranet\User_Controller();
	new Rubicore\AlingsasIntranet\Mail_Controller();
	new Rubicore\AlingsasIntranet\Post_Controller();
	new Rubicore\AlingsasIntranet\Job_Controller();


	add_filter('rubicore_capability_list', function ($capability_list) {
		$custom = [
			['group' => 'custom_akp', 'key' => 'akp_communal_post', 'desc' => 'Skapa kommungemensamt inlägg'],
			['group' => 'custom_akp', 'key' => 'akp_sync_tools', 'desc' => 'Koppla verktyg (CRON)'],
			['group' => 'custom_akp', 'key' => 'akp_full_cms_editor', 'desc' => 'Fullständig editor'],
			['group' => 'custom_akp', 'key' => 'akp_old_post_reminder', 'desc' => 'Skicka påminnelsemail om gamla sidor (CRON)']
		];

		return array_merge($capability_list, $custom);
	});
});


add_action('admin_init', function () {
	RUBICORE_AlingsasIntranet_check_dependencies();
});
