<?php

namespace Rubicore\AlingsasIntranet;

final class Job_Repository
{
	private string $list_url = "http://recruit.visma.com/External/Feeds/AssignmentList.ashx?guidGroup=7900277d-cd09-4994-9659-b9be96aeba25";
	private string $single_url = "https://recruit.visma.com/External/Feeds/AssignmentItem.ashx?guidGroup=7900277d-cd09-4994-9659-b9be96aeba25&guidAssignment=";

	public function list() : object
	{
		$remote_options = [
			'method' => 'GET',
			'timeout' => 45,
			'headers' => []
		];

		$response = wp_remote_request($this->list_url, $remote_options);

		if (is_wp_error($response)) {
			$error_message = $response->get_error_message();
			\Rubicore\Core\Response_Helper::die($error_message);
		}

		return new \SimpleXMLElement($response['body']);
	}

	public function get(string $guid) : object {
		$remote_options = [
			'method' => 'GET',
			'timeout' => 45,
			'headers' => []
		];

		$response = wp_remote_request("{$this->single_url}{$guid}", $remote_options);

		if (is_wp_error($response)) {
			$error_message = $response->get_error_message();
			\Rubicore\Core\Response_Helper::die($error_message);
		}

		return new \SimpleXMLElement($response['body']);
	}
}
